

#ifndef __jabber_meeting_account_sync_h__
#define __jabber_meeting_account_sync_h__

#include <string>
#include <list>
#include "MeetingSiteImpl.h"
#include "csf/Timer.hpp"
#include "csfunified/framework/UnifiedFactory.h"
#include "csf/Thread.hpp"
#include "csf/Runnable.hpp"

namespace CSFUnified
{
    enum JABBER_MEETING_ACCOUNT_ERROR_CODE
    {
        e_jmaec_success = 0,
        e_jmaec_error_timeout,
        e_jmaec_error_network,
        e_jmaec_error_setup_error,
        e_jmaec_error_wapi_failed,
        e_jmaec_error_ref_string,
        e_jmaec_error_site_url_Invalid,
        e_jmaec_error_account_not_found,
        e_jmaec_error_account_password_invalid,
        e_jmaec_error_login_required,
        e_jmaec_error_account_no_user,
        e_jmaec_error_account_user_inactive,
        e_jmaec_error_account_login_failed,
        e_jmaec_error_account_deactivated,
        e_jmaec_error_account_verify_sso_centersite_failed,
        e_jmaec_error_account_association_delete_failed,
        e_jmaec_error_account_has_been_locked,
        e_jmaec_error_account_password_has_expired,
        e_jmaec_error_account_unavailable,
        e_jmaec_error_account_locked,
        e_jmaec_error_account_creation_failed,
        e_jmaec_error_account_creation_not_allowed,
        e_jmaec_error_account_password_force_change,
        e_jmaec_error_account_password_reset,
        e_jmaec_error_account_password_tmp_exp,
        e_jmaec_error_account_site_url_not_found,
        e_jmaec_error_account_sso_not_allowed,
        e_jmaec_error_account_site_release_not_support,
        e_jmaec_error_site_maintenance,
        e_jmaec_error_account_name_empty,
        e_jmaec_error_donot_support_attendeerole,
        e_jmaec_error_certification_verify_failed
    };
    
    
    class IJabberMeetingAccountEvent
    {
    public:
        virtual void onGetAllSite(bool isSuccess, std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList) = 0;
        virtual void onGetDefaultSite(JABBER_MEETING_ACCOUNT_ERROR_CODE errorCode, std::string errorMsge, SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime) = 0;
		virtual void onSetDefaultSite(JABBER_MEETING_ACCOUNT_ERROR_CODE errorCode, std::string errorMsge, SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime) = 0;
    };
    
    class IJabberMeetingAccountSync
    {
    public:
        virtual void start() = 0;
        virtual void stop() = 0;
        virtual void syncAllSite() = 0;
        virtual void getDefaultSite() = 0;
        virtual void setDefaultSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime) = 0;
        virtual void deleteSite(std::string siteUrl) = 0;
        virtual void updateAllSite(std::string defaultSiteUrl, MeetingSiteImpl* addedSite, std::string deletedSiteUrl) = 0;
    };
    
    
    class newTimerCallBack
    {
    public:
        virtual void onTimer() = 0;
    };
    
    class newTimer : public csf::Runnable
    {
    public:
        ~newTimer()
        {
            m_pSink = NULL;
        }
        
        static newTimer* getInstant()
        {
            static newTimer* pTimer = NULL;
            if(NULL == pTimer)
            {
                pTimer = new newTimer;
            }
            return pTimer;
        }
        
        void startTimer(newTimerCallBack * pSink, int sec)
        {
            if (m_thread.isRunning())
            {
                return;
            }
            m_pSink = pSink;
            m_secForSleep = sec;
            m_bEndThread = false;
            m_thread.start(*this);
        }
        
        void stopTimer()
        {
            m_bEndThread = true;
            m_pSink = NULL;
        }
        
        bool isRunning()
        {
            return m_thread.isRunning();
        }
    protected:
        virtual void run()
        {
            while (!m_bEndThread)
            {
                if (NULL != m_pSink)
                {
                    m_pSink->onTimer();
                }
                m_thread.sleep(m_secForSleep);
            }
        }
        
        newTimer()
        {
            m_pSink = NULL;
            m_secForSleep = 0;
            m_bEndThread = true;
        }
        
    private:
        int m_secForSleep;
        csf::Thread m_thread;
        bool m_bEndThread;
        newTimerCallBack* m_pSink;
    };
    
    
    
}

#endif//__meeting_account_sync_h__

